VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cShapeStar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private WithEvents ROuter As cControlPoint
Attribute ROuter.VB_VarHelpID = -1
Private WithEvents RInner As cControlPoint
Attribute RInner.VB_VarHelpID = -1
Private WithEvents CenterDrag As cControlPoint
Attribute CenterDrag.VB_VarHelpID = -1

Public Sub Init(Controlpoints As cControlPoints, ByVal X As Double, ByVal Y As Double, ByVal RadiusOuter As Double, ByVal RadiusInner As Double)
  Set ROuter = Controlpoints.Add("ROuter" & ObjPtr(Me), X + RadiusOuter, Y, vbGreen, 6)
  Set RInner = Controlpoints.Add("RInner" & ObjPtr(Me), X + RadiusInner, Y, vbGreen, 6)
  Set CenterDrag = Controlpoints.Add("CenterDrag" & ObjPtr(Me), X, Y, vbMagenta, 9)
End Sub

Public Sub Draw(CC As cCairoContext)
Dim i&, Colors&(2), Patterns(2) As cCairoPattern 'one separate Pattern for each corner of the star
Dim Angle As Double, RotX As Double, RotY As Double, M As cCairoMatrix '<- these are used, to calculate Corner-positions
  
  'just the preparation of a small Color-Lookup-Table (Red, Green and Blue - for each different Corner of our 3-Point-Star)
  Colors(0) = vbRed: Colors(1) = vbGreen: Colors(2) = vbBlue
  
  CC.Save
    'as always, we define the path first... (in this case a "3-point-star" is created)
    CC.DrawRegularPolygon CenterDrag.X, CenterDrag.Y, RadiusOuter, 3, splSmall, RadiusInner
    
    'now the Pattern-Creation (3 differently directed linear patterns are used)
    Angle = 360 / 3 'we define our Angle-Stepwidth here (360 divided by 3, according to our 3-point-star)
    RotX = 0: RotY = -RadiusOuter  'this places the Start-RotationPoint at the top-corner of the star
    
    Set M = Cairo.CreateIdentityMatrix 'and to avoid our own "vector-math-fiddeling", ...
    M.RotateCoordsDeg Angle '...we just use a Cairo-Matrix to ease our Angle-Vector calculations
    
    For i = 0 To 2 'here we construct the 3 different linear-patterns, accordingly to the "Angle-Step"
      Set Patterns(i) = Cairo.CreateLinearPattern(CenterDrag.X, CenterDrag.Y, CenterDrag.X + RotX, CenterDrag.Y + RotY)
        Patterns(i).AddColorStop 0, vbWhite, 0
        Patterns(i).AddColorStop 1, Colors(i), 1
      CC.Fill True, Patterns(i) 'note, that with the "True"-parameter, even different added patterns "stack-up"
      
      M.CalculatePoint RotX, RotY  'recalculate and change RotX and RotY here, to prepare out relative Rotation-Vector-Coords for the next round
    Next i
    
    CC.SetSourceColor vbBlack, 0.5
    CC.Stroke '*now* the Path gets closed (no Optional DontClosePath-Param set) - and we ensure thereby a combined Fill+Stroke
  CC.Restore
End Sub

Public Property Get RadiusOuter() As Double
  RadiusOuter = ROuter.X - CenterDrag.X
End Property
Public Property Get RadiusInner() As Double
  RadiusInner = RInner.X - CenterDrag.X
End Property


'Control-Point Movement-Events are received below, and we will act accordingly with the necessary adaptions

Private Sub Router_PositionChanging(NewX As Double, NewY As Double)
  NewY = CenterDrag.Y
  
  If NewX - CenterDrag.X < 20 Then NewX = CenterDrag.X + 20 'we restrict the outer Radius to min 20 pixels
  If NewX - RInner.X < 10 Then NewX = RInner.X + 10 'we restrict the distance between Inner and outer Radius to 10 pixels
End Sub
Private Sub Rinner_PositionChanging(NewX As Double, NewY As Double)
  NewY = CenterDrag.Y
  
  If NewX - CenterDrag.X < 10 Then NewX = CenterDrag.X + 10 'we restrict the inner Radius to min 10 pixels
  If ROuter.X - NewX < 10 Then NewX = ROuter.X - 10 'we restrict the distance between Inner and outer Radius to 10 pixels
End Sub
Private Sub CenterDrag_PositionChanging(NewX As Double, NewY As Double)
Dim RO#, RI#
  RO = RadiusOuter: RI = RadiusInner 'we need to buffer the current Radie beforehand, to not mess-up the coord-adaptions below, since both are dynamically calculated in Properties
  
  ROuter.X = NewX + RO
  ROuter.Y = NewY
  
  RInner.X = NewX + RI
  RInner.Y = NewY
End Sub


